// Cursor.js by Radnen //

function Cursor(filename)
{
	this.image   = LoadImage(filename);
	this.idle    = true;
	this.x = 0; this.y = 0;
	this.pressed = false;
}

Cursor.prototype.draw = function()
{
	this.image.blit(this.x, this.y);
}

Cursor.prototype.update = function()
{
	if (!this.idle)
	{
		this.x = GetMouseX();
		this.y = GetMouseY();
	}
	if (this.idle && this.x != GetMouseX() && this.y != GetMouseY()) this.idle = false;
	if (!IsMouseButtonPressed(MOUSE_LEFT)) this.pressed = false;
}